/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.lib.util.helpers.StringHelper;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredRegisterCoFH<T extends IForgeRegistryEntry<T>> {
    private final ResourceLocation registryName;
    private final String modid;
    private final Map<RegistryObject<T>, Supplier<? extends T>> entries = new LinkedHashMap<RegistryObject<T>, Supplier<? extends T>>();
    private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    private final Map<ResourceLocation, RegistryObject> registryObjects = new HashMap<ResourceLocation, RegistryObject>();
    private IForgeRegistry<T> type;
    private Supplier<IForgeRegistry<T>> typeSupplier;
    private Supplier<RegistryBuilder<T>> registryFactory;
    private SetMultimap<TagKey<T>, Supplier<T>> optionalTags;
    private boolean preventDataFixers;

    public static <B extends IForgeRegistryEntry<B>> DeferredRegisterCoFH<B> create(IForgeRegistry<B> reg, String modid) {
        return new DeferredRegisterCoFH<B>(reg, modid);
    }

    public static <B extends IForgeRegistryEntry<B>> DeferredRegisterCoFH<B> create(ResourceKey<? extends Registry<B>> key, String modid) {
        return new DeferredRegisterCoFH(key.m_135782_(), modid);
    }

    public static <B extends IForgeRegistryEntry<B>> DeferredRegisterCoFH<B> create(ResourceLocation registryName, String modid) {
        return new DeferredRegisterCoFH(registryName, modid);
    }

    private DeferredRegisterCoFH(@Nullable ResourceLocation registryName, String modid) {
        this.registryName = registryName;
        this.modid = modid;
    }

    private DeferredRegisterCoFH(IForgeRegistry<T> reg, String modid) {
        this(reg.getRegistryName(), modid);
        this.type = reg;
    }

    public DeferredRegisterCoFH<T> preventDataFixers(boolean preventDataFixers) {
        this.preventDataFixers = preventDataFixers;
        return this;
    }

    public synchronized <I extends T> RegistryObject<I> register(String resourceLoc, Supplier<I> sup) {
        return this.register(StringHelper.decompose(this.modid, resourceLoc, ':'), sup);
    }

    private synchronized <I extends T> RegistryObject<I> register(String[] resourceLoc, Supplier<I> sup) {
        return this.register(resourceLoc[0], resourceLoc[1], sup);
    }

    public synchronized <I extends T> RegistryObject<I> register(String modid, String name, Supplier<I> sup) {
        return this.register(new ResourceLocation(modid, name), sup);
    }

    public synchronized <I extends T> RegistryObject<I> register(ResourceLocation resourceLoc, Supplier<I> sup) {
        RegistryObject ret;
        if (this.registryObjects.containsKey(resourceLoc)) {
            return this.registryObjects.get(resourceLoc);
        }
        IForgeRegistry<T> reg = this.getForgeRegistry();
        if (reg != null) {
            ret = RegistryObject.of((ResourceLocation)resourceLoc, reg);
        } else if (this.registryName != null) {
            ret = RegistryObject.of((ResourceLocation)resourceLoc, (ResourceLocation)this.registryName, (String)this.modid);
        } else {
            throw new IllegalStateException("Could not create RegistryObject in DeferredRegister");
        }
        this.entries.put(ret, () -> (IForgeRegistryEntry)((IForgeRegistryEntry)sup.get()).setRegistryName(resourceLoc));
        this.registryObjects.put(resourceLoc, ret);
        return ret;
    }

    public Supplier<IForgeRegistry<T>> makeRegistry(Class<T> base, Supplier<RegistryBuilder<T>> sup) {
        return this.makeRegistry(this.registryName, base, sup);
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull String path) {
        Objects.requireNonNull(path);
        return this.createTagKey(new ResourceLocation(this.modid, path));
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull ResourceLocation location) {
        if (this.registryName == null) {
            throw new IllegalStateException("The registry name was not set, cannot create a tag key");
        }
        Objects.requireNonNull(location);
        return TagKey.m_203882_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)this.registryName), (ResourceLocation)location);
    }

    @NotNull
    public TagKey<T> createOptionalTagKey(@NotNull String path, @NotNull Set<? extends Supplier<T>> defaults) {
        Objects.requireNonNull(path);
        return this.createOptionalTagKey(new ResourceLocation(this.modid, path), defaults);
    }

    @NotNull
    public TagKey<T> createOptionalTagKey(@NotNull ResourceLocation location, @NotNull Set<? extends Supplier<T>> defaults) {
        TagKey<T> tagKey = this.createTagKey(location);
        this.addOptionalTagDefaults(tagKey, defaults);
        return tagKey;
    }

    public void addOptionalTagDefaults(@NotNull TagKey<T> name, @NotNull Set<? extends Supplier<T>> defaults) {
        Objects.requireNonNull(defaults);
        if (this.optionalTags == null) {
            this.optionalTags = Multimaps.newSetMultimap(new IdentityHashMap(), HashSet::new);
        }
        this.optionalTags.putAll(name, defaults);
    }

    public T get(String resourceLoc) {
        return this.get(StringHelper.decompose(this.modid, resourceLoc, ':'));
    }

    private T get(String[] resourceLoc) {
        return this.get(resourceLoc[0], resourceLoc[1]);
    }

    public T get(String modid, String name) {
        return this.get(new ResourceLocation(modid, name));
    }

    public T get(ResourceLocation resourceLoc) {
        RegistryObject reg = this.registryObjects.get(resourceLoc);
        return (T)(reg == null ? null : (IForgeRegistryEntry)reg.get());
    }

    public RegistryObject<T> getSup(String resourceLoc) {
        return this.getSup(StringHelper.decompose(this.modid, resourceLoc, ':'));
    }

    private RegistryObject<T> getSup(String[] resourceLoc) {
        return this.getSup(resourceLoc[0], resourceLoc[1]);
    }

    public RegistryObject<T> getSup(String modid, String name) {
        return this.getSup(new ResourceLocation(modid, name));
    }

    @Nullable
    public RegistryObject<T> getSup(ResourceLocation resourceLoc) {
        return this.registryObjects.get(resourceLoc);
    }

    public void register(IEventBus bus) {
        bus.register((Object)new EventDispatcher(this));
        if (this.type == null && this.registryFactory != null) {
            bus.addListener(this::createRegistry);
        }
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    private Supplier<IForgeRegistry<T>> makeRegistry(ResourceLocation registryName, Class<T> superType, Supplier<RegistryBuilder<T>> sup) {
        if (registryName == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a registry name");
        }
        if (superType == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a base type");
        }
        if (this.type != null || this.registryFactory != null) {
            throw new IllegalStateException("Cannot create a registry for a type that already exists");
        }
        this.registryFactory = () -> ((RegistryBuilder)sup.get()).setName(registryName).setType(superType);
        return this::getForgeRegistry;
    }

    private IForgeRegistry<T> getForgeRegistry() {
        if (this.type == null && this.typeSupplier != null) {
            this.type = this.typeSupplier.get();
        }
        return this.type;
    }

    private void onFill(IForgeRegistry<T> registry) {
        if (this.optionalTags == null) {
            return;
        }
        ITagManager tagManager = registry.tags();
        if (tagManager == null) {
            throw new IllegalStateException("The forge registry " + registry.getRegistryName() + " does not support tags, but optional tags were registered!");
        }
        Multimaps.asMap(this.optionalTags).forEach((arg_0, arg_1) -> ((ITagManager)tagManager).addOptionalTagDefaults(arg_0, arg_1));
    }

    private void addEntries(RegistryEvent.Register<?> event) {
        IForgeRegistry<T> storedType = this.getForgeRegistry();
        if (storedType == null && this.registryFactory == null) {
            this.captureRegistry();
            storedType = this.type;
        }
        if (storedType != null && event.getGenericType() == storedType.getRegistrySuperType()) {
            IForgeRegistry reg = event.getRegistry();
            for (Map.Entry<RegistryObject<T>, Supplier<T>> e : this.entries.entrySet()) {
                reg.register((IForgeRegistryEntry)e.getValue().get());
                e.getKey().updateReference(reg);
            }
        }
    }

    private void createRegistry(NewRegistryEvent event) {
        this.typeSupplier = event.create(this.registryFactory.get(), this::onFill);
    }

    private void captureRegistry() {
        if (this.registryName != null) {
            this.type = RegistryManager.ACTIVE.getRegistry(this.registryName);
            if (this.type == null) {
                throw new IllegalStateException("Unable to find registry with key " + this.registryName + " for modid \"" + this.modid + "\" after NewRegistry event");
            }
        } else {
            throw new IllegalStateException("Unable to find registry for mod \"" + this.modid + "\" No lookup criteria specified.");
        }
    }

    public static class EventDispatcher {
        private final DeferredRegisterCoFH<?> register;

        public EventDispatcher(DeferredRegisterCoFH<?> register) {
            this.register = register;
        }

        @SubscribeEvent
        public void handleEvent(RegistryEvent.Register<?> event) {
            if (this.register.preventDataFixers) {
                SharedConstants.f_136182_ = false;
            }
            this.register.addEntries(event);
            if (this.register.preventDataFixers) {
                SharedConstants.f_136182_ = true;
            }
        }
    }
}

